#include "stdafx.h"
#include "printer_base.h"
/*
 * ///////////////////////////////////
 * define
 * //////////////////////////////////
 */
pPrinterCreator		                   PrinterCreator;
pPrinterCreatorS	                   PrinterCreatorS;
pPrinterDestroy		                   PrinterDestroy;
pPortOpen		                       PortOpen;
pPortClose		                       PortClose;
pWriteData                             WriteData;
pReadData							   ReadData;
pDirectIO		                       DirectIO;
ZPL_GetPrinterDpi		               GetPrinterDpi;
ZPL_StartFormat		                   StartFormat;
ZPL_GetPrinterStatus		           GetPrinterStatus;
ZPL_EndFormat		                   EndFormat;
ZPL_SetChangeFontEncoding              SetChangeFontEncoding;
ZPL_SetVietMode						   SetVietMode;
ZPL_SetVietFontEncoding				   SetVietFontEncoding;
ZPL_SetUserFontName					   PrintSetUserFontName;
ZPL_Text							   PrintText;
ZPL_Text_Block			               PrintTextBlock;
ZPL_BarCode39			               BarCode39;
ZPL_Pdf417			                   Pdf417;
ZPL_MicroPdf417			               MicroPdf417;
ZPL_SetLabelHome					   SetLabelHome;
ZPL_SetLabelLength					   SetLabelLength;
ZPL_SetTearOffAdjustPosition		   SetTearOffAdjustPosition;
ZPL_CodeEan8			               CodeEan8;
ZPL_QRCode			                   QRCode;
ZPL_UpcExtensions		               UpcExtensions;
ZPL_UpcaBarcode			               UpcaBarcode;
ZPL_GraphicBox			               GraphicBox;
ZPL_GraphicCircle		               GraphicCircle;
ZPL_GraphicDiagonalLine		           GraphicDiagonaline;
ZPL_GraphicEllipse		               GraphicEllipse;
ZPL_GraphicSymbol		               GraphicSymbol;
ZPL_PrintImage                         PrintImage;
ZPL_SetDiagnosticsMode		           SetDiagnosticsMode;
ZPL_SetPrintRate		               SetPrintRate;
ZPL_SetPrintDarkness		           SetPrintDarkness;
ZPL_PrintConfigurationLabel	           PrintConfigurationLabel;
ZPL_SetSerialCommunications	           SetSerialCommunications;
ZPL_SetPrintMode					   SetPrintMode;
ZPL_SetPrintQuantity				   SetPrintQuantity;
ZPL_RfidWrite						   RfidWrite;
ZPL_RfidRead					       RfidRead;
ZPL_RfidCalibration					   RfidCalibration;

void	* hprinter;
HMODULE m_hDll;

void UnloadDll()
{
	FreeLibrary( m_hDll );
}


BOOL LoadDll()
{
	m_hDll = LoadLibrary( _T( "ZPL_SDK.dll" ) );
	if ( m_hDll == 0 )
		return(FALSE);

	PrinterCreator			= (pPrinterCreator) GetProcAddress( m_hDll, "PrinterCreator" );
	PrinterCreatorS			= (pPrinterCreatorS) GetProcAddress( m_hDll, "PrinterCreatorS" );
	PrinterDestroy          = (pPrinterDestroy)GetProcAddress(m_hDll, "PrinterDestroy");
	PortOpen                = (pPortOpen)GetProcAddress(m_hDll, "PortOpen");
	PortClose				= (pPortClose) GetProcAddress( m_hDll, "PortClose" );
	WriteData				= (pWriteData)GetProcAddress(m_hDll, "WriteData");
	ReadData				= (pReadData)GetProcAddress(m_hDll, "ReadData");
	DirectIO				= (pDirectIO) GetProcAddress( m_hDll, "DirectIO" );
	GetPrinterDpi			= (ZPL_GetPrinterDpi) GetProcAddress( m_hDll, "ZPL_GetPrinterDpi" );
	StartFormat				= (ZPL_StartFormat) GetProcAddress( m_hDll, "ZPL_StartFormat" );
	GetPrinterStatus		= (ZPL_GetPrinterStatus) GetProcAddress( m_hDll, "ZPL_GetPrinterStatus" );
	EndFormat				= (ZPL_EndFormat) GetProcAddress( m_hDll, "ZPL_EndFormat" );
	SetChangeFontEncoding   = (ZPL_SetChangeFontEncoding)GetProcAddress(m_hDll, "ZPL_SetChangeFontEncoding");
	SetVietMode				= (ZPL_SetVietMode)GetProcAddress(m_hDll, "ZPL_SetVietMode");
	SetVietFontEncoding		= (ZPL_SetVietFontEncoding)GetProcAddress(m_hDll, "ZPL_SetVietFontEncoding");
	PrintSetUserFontName	= (ZPL_SetUserFontName) GetProcAddress( m_hDll, "ZPL_SetUserFontName" );
	PrintText				= (ZPL_Text) GetProcAddress( m_hDll, "ZPL_Text" );
	PrintTextBlock			= (ZPL_Text_Block) GetProcAddress( m_hDll, "ZPL_Text_Block" );
	BarCode39				= (ZPL_BarCode39) GetProcAddress( m_hDll, "ZPL_BarCode39" );
	Pdf417					= (ZPL_Pdf417) GetProcAddress( m_hDll, "ZPL_Pdf417" );
	MicroPdf417				= (ZPL_MicroPdf417) GetProcAddress( m_hDll, "ZPL_MicroPdf417" );
	SetLabelHome			= (ZPL_SetLabelHome) GetProcAddress( m_hDll, "ZPL_SetLabelHome" );
	SetLabelLength			= (ZPL_SetLabelLength) GetProcAddress( m_hDll, "ZPL_SetLabelLength" );
	SetTearOffAdjustPosition= (ZPL_SetTearOffAdjustPosition) GetProcAddress( m_hDll, "ZPL_SetTearOffAdjustPosition" );
	CodeEan8				= (ZPL_CodeEan8) GetProcAddress( m_hDll, "ZPL_CodeEan8" );
	QRCode				    = (ZPL_QRCode) GetProcAddress( m_hDll, "ZPL_QRCode" );
	UpcExtensions			= (ZPL_UpcExtensions) GetProcAddress( m_hDll, "ZPL_UpcExtensions" );
	UpcaBarcode			    = (ZPL_UpcaBarcode) GetProcAddress( m_hDll, "ZPL_UpcaBarcode" );
	GraphicBox			    = (ZPL_GraphicBox) GetProcAddress( m_hDll, "ZPL_GraphicBox" );
	GraphicCircle			= (ZPL_GraphicCircle) GetProcAddress( m_hDll, "ZPL_GraphicCircle" );
	GraphicDiagonaline		= (ZPL_GraphicDiagonalLine) GetProcAddress( m_hDll, "ZPL_GraphicDiagonalLine" );
	GraphicEllipse			= (ZPL_GraphicEllipse) GetProcAddress( m_hDll, "ZPL_GraphicEllipse" );
	GraphicSymbol			= (ZPL_GraphicSymbol) GetProcAddress( m_hDll, "ZPL_GraphicSymbol" );
	PrintImage              = (ZPL_PrintImage)GetProcAddress( m_hDll, "ZPL_PrintImage");
	SetDiagnosticsMode		= (ZPL_SetDiagnosticsMode) GetProcAddress( m_hDll, "ZPL_SetDiagnosticsMode" );
	SetPrintRate			= (ZPL_SetPrintRate) GetProcAddress( m_hDll, "ZPL_SetPrintRate" );
	SetPrintDarkness		= (ZPL_SetPrintDarkness) GetProcAddress( m_hDll, "ZPL_SetPrintDarkness" );
	PrintConfigurationLabel	= (ZPL_PrintConfigurationLabel) GetProcAddress( m_hDll, "ZPL_PrintConfigurationLabel" );
	SetSerialCommunications	= (ZPL_SetSerialCommunications) GetProcAddress( m_hDll, "ZPL_SetSerialCommunications" );
	SetPrintMode			= (ZPL_SetPrintMode) GetProcAddress( m_hDll, "ZPL_SetPrintMode" );
	SetPrintQuantity		= (ZPL_SetPrintQuantity) GetProcAddress( m_hDll, "ZPL_SetPrintQuantity" );
	RfidWrite				= (ZPL_RfidWrite) GetProcAddress( m_hDll, "ZPL_RfidWrite" );
	RfidRead				= (ZPL_RfidRead) GetProcAddress( m_hDll, "ZPL_RfidRead" );
	RfidCalibration			= (ZPL_RfidCalibration) GetProcAddress( m_hDll, "ZPL_RfidCalibration" );
	

	return(TRUE);
}